package actions;
import world.*;

/**
 * A class that represents move actions for agents that inhabit grid-like
 * worlds in which crashes cause reorientation.
 * @author Derek Bridge
 */
public class Bounce
   extends Action
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new bounce action.
    */
   public Bounce()
   {  move = new Move();
      turn = new Turn(Turn.LEFT);
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns a string representation of this expression.
    */
   public String toString()
   {  return "bounce";
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Carry out the action in the world.
    * @param theAgent the agent who is executing this action.
    */
   public void execute(Agent theAgent)
   {  move.execute(theAgent);
      if (move.didCrash())
      {  turn.setTurn(((int) (Math.random() * 2)), 
            ((int) (Math.random() * World.NUM_OF_COMPASS_POINTS)));
         turn.execute(theAgent);
      }
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private Move move;
   private Turn turn;
}
